<?php
add_filter( 'widget_text', 'shortcode_unautop');
add_filter( 'widget_text', 'do_shortcode');

add_action( 'wp_enqueue_scripts', 'my_enqueue_styles' );
add_action( 'after_setup_theme', 'my_child_theme_setup' );

function my_child_theme_setup() {
	load_child_theme_textdomain( 'bloggr', get_stylesheet_directory() . '/languages' );
}

function mysql_real_escape_string($string){
	$con = new mysqli("localhost", "Administrador", "Administrador", "iwatchcommodity");
	return mysqli_real_escape_string($con,$string);
}


function my_enqueue_styles() {

	/* If using a child theme, auto-load the parent theme style. */
	if ( is_child_theme() ) {
		//wp_enqueue_style( 'parent-style', trailingslashit( get_template_directory_uri() ) . 'style.css' );
	}

	/* Always load active theme's style.css. */
	wp_enqueue_style( 'style', get_stylesheet_uri() );
	wp_enqueue_style( 'bloggr-google-fonts', '//fonts.googleapis.com/css?family=Material+Icons' );
	
}
if ( ! function_exists( 'bloggr_entry_footer_ID' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
*/
function bloggr_entry_footer_ID($ID) {
	// Hide category and tag text for pages.

	?>
		<p class="action_favorito">
		<?php
		
		$rel = get_user_relation_id( get_current_user_id() , 0, $ID, 'favorite' );
		if($rel):?>
				<i  id="icon_favourite_<?php echo $ID;?>" class="fa fa-heart" style="margin-left:10px;font-size:24px;color:red;cursor:pointer;vertical-align:middle;" onclick="marcaPostFavorito(<?php echo '\''.$ID.'\'';?>)"></i>			 					
		 <?php else: ?>
				<i id="icon_favourite_<?php echo $ID;?>" class="fa fa-heart" style="margin-left:10px;font-size:24px;color:#404040;cursor:pointer;vertical-align:middle;" onclick="marcaPostFavorito(<?php echo '\''.$ID.'\'';?>)"></i>
						 	    
		 <?php endif; 
		 	 $url_article = get_post_meta( $ID, 'url_article', true );?>
		 
		  <i class="material-icons" style="margin-left:10px;font-size:24px;color:#404040;cursor:pointer;vertical-align:middle;" onclick="mostrar_enviar_a(<?php echo '\''.$ID.'\'';?>)">email</i>
		   <i id="icon_share_<?php echo $ID;?>" class="fa fa-share-alt" style="margin-left:10px;font-size:24px;color:#404040;cursor:pointer;vertical-align:middle;" onclick="mostrar_recomendar_a(<?php echo '\''.$ID.'\'';?>)"></i>
		  <a href="<?php echo $url_article;?>" target="_blank">
		  	<i id="icon_share_<?php echo $ID;?>" class="fa fa-share-square-o" style="margin-left:10px;font-size:24px;color:#404040;cursor:pointer;vertical-align:middle;" ></i>
			</a>
			<?php 
			if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
				//echo '<i class="fa fa-comments-o"></i> ';
				comments_popup_link( __( '<i class="fa fa-comments-o" style="margin-left:10px;font-size:24px;color:#404040;vertical-align:middle;"></i>', 'bloggr' ), __( '1 Comment', 'bloggr' ), __( '% Comments', 'bloggr' ) );
				//echo '';
			}
			
			//edit_post_link( __( 'Edit', 'bloggr' ) );
			?>	
			
				<i id="icon_delete_<?php echo $ID;?>" class="fa fa-trash" style="margin-left:10px;font-size:24px;color:#404040;cursor:pointer;vertical-align:middle;" onclick="marcaPostBorrado(<?php echo '\''.$ID.'\'';?>)"></i>
			
			 <p id="server_message-<?php echo $ID;?>" style="display:none">Esto es un mensaje</p>

		<?php
}
endif;
function bloggr_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' == get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( __( ', ', 'bloggr' ) );
		if ( $categories_list && bloggr_categorized_blog() ) {
			printf( '<span class="cat-links"><i class="fa fa-pencil"></i></span>', $categories_list );
		}

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', __( ', ', 'bloggr' ) );
		if ( $tags_list ) {
			printf( '<span class="tags-links"><i class="fa fa-tag"></i> ' . __( 'Tagged %1$s', 'bloggr' ) . '</span>', $tags_list );
		}
	}

	if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		echo '<span class="comments-link"><i class="fa fa-comments-o"></i> ';
		comments_popup_link( __( 'Leave a comment', 'bloggr' ), __( '1 Comment', 'bloggr' ), __( '% Comments', 'bloggr' ) );
		echo '</span>';
	}

	edit_post_link( __( 'Edit', 'bloggr' ), '<span class="edit-link">', '</span>' );
}

if ( ! function_exists( 'bloggr_post_nav' ) ) :
/**
 * Display navigation to next/previous post when applicable.
*/
function bloggr_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Post navigation', 'bloggr' ); ?></h1>
		<div id="nav-links" class="nav-links">
			<?php
				previous_post_link( '<div id="nav-previous" class="nav-previous"><span class="valign">%link</span></div>', _x( '<span class="meta-nav">&larr;</span>&nbsp;%title', 'Previous post link', 'bloggr' ) );
				next_post_link(     '<div id="nav-next" class="nav-next">%link</div>',     _x( '%title&nbsp;<span class="meta-nav">&rarr;</span>', 'Next post link',     'bloggr' ) );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'bloggr_paging_nav' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
*/
function bloggr_paging_nav() {
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}
	?>
	<nav class="navigation paging-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Posts navigation', 'bloggr' ); ?></h1>
		<div class="nav-links">

			<?php if ( get_next_posts_link() ) : ?>
			<div  id="nav-previous" class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'bloggr' ) ); ?></div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link() ) : ?>
			<div id="nav-next" class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'bloggr' ) ); ?></div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;
if ( ! function_exists( 'bloggr_child_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
*/
function bloggr_child_posted_on() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
			);

	$posted_on = sprintf(
			_x( '<i class="fa fa-clock-o"></i> %s', 'post date', 'bloggr' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
			);

	$byline = sprintf(
			_x( '<span class="hide-on-mobile">by %s</span>', 'post author', 'bloggr' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
			);

	echo '<span class="posted-on">' . $posted_on . '</span><span class="byline"> ' . $byline . '</span>';

}
endif;

